using System;
using System.Xml;
using System.Collections.Generic;
using System.Text;

namespace ReadWriteXml
{
   class Program
   {
      static void Main(string[] args)
      {
         XmlDocument itemDoc = new XmlDocument();
         itemDoc.Load(@"..\..\..\..\przedmioty.xml");
         Console.WriteLine("DocumentElement ma {0} potomkw.",
           itemDoc.DocumentElement.ChildNodes.Count);

         // iteruj po elementach najwyszego poziomu
         foreach (XmlNode itemNode in itemDoc.DocumentElement.ChildNodes)
         {
            // poniewa wiemy, e wze jest elementem, moemy zrobi tak:
            XmlElement itemElement = (XmlElement)itemNode;
            Console.WriteLine("\n[Przedmiot]: {0}\n{1}",
               itemElement.Attributes["name"].Value,
               itemElement.Attributes["description"].Value);
            if (itemNode.ChildNodes.Count == 0)
               Console.WriteLine("(Brak dodatkowych informacji)\n");
            else
            {
               foreach (XmlNode childNode in itemNode.ChildNodes)
               {
                  if (childNode.Name.ToUpper() == "ATTRIBUTE")
                     Console.WriteLine("{0} : {1}",
                        childNode.Attributes["name"].Value,
                        childNode.Attributes["value"].Value);
                  else if (childNode.Name.ToUpper() == "SPECIALS")
                  {
                     foreach (XmlNode specialNode in childNode.ChildNodes)
                     {
                        Console.WriteLine("*{0} : {1}",
                           specialNode.Attributes["name"].Value,
                           specialNode.Attributes["description"].Value);
                     }
                  }
               }
            }
         }
         Console.ReadLine();
      }
   }
}
